package daos;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import entities.Employee;

public class EmployeeDao {

	EntityManager manager;

	public EmployeeDao(EntityManager manager) {
		this.manager = manager;
	}
	
	@SuppressWarnings("unchecked")
	public List<Object[]> selectAllNamesAndBirthday(){
		Query query = manager.createNamedQuery("Employee.selectAllNamesAndBirthday");
		return query.getResultList();
	}
	
	@SuppressWarnings("unchecked")
	public List<String> selectAllNames(){
		Query query = manager.createNamedQuery("Employee.selectAllNames");
		return query.getResultList();
	}

	@SuppressWarnings("unchecked")
	public List<Employee> selectWithSalaryGreaterThan(double salary){
		
		Query query = manager.createNamedQuery("Employee.selectWithSalaryGreaterThan");
		query.setParameter("salary", salary);
		
		return query.getResultList();
	}
	
	public void insert(Employee employee) {
		manager.persist(employee);
	}
	
	public List<Employee> select() {
		
		Query query = manager.createQuery("SELECT p FROM Employee p");
		
		@SuppressWarnings("unchecked")
		List<Employee> employees = query.getResultList();

		return employees;
	}

	public Employee selectById(long id) {
		return manager.find(Employee.class, id);
	}

	public void deleteById(long id) {

		Employee employee = selectById(id);

		if (employee != null) {
			manager.remove(employee);
		}
	}
	
	public void update(long id, double newSalary){
		Employee e = manager.find(Employee.class, id);
		e.setSalary(newSalary);
	}

}
